// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef GP_DLREC_H
#define GP_DLREC_H

#include "container.h"
#include "array.h"
#include "recbase.h"
#include "gp_internal.h"

struct POS_INDEX {
	DWORD pos;
	size_t index;
};

class DLRecBuf : public RecBufBase {
public:
	void request_dword_ptr(size_t index);
	const vector<POS_INDEX>& dprv() const { return r_dp_v; }
private:
	vector<POS_INDEX> r_dp_v; //DWORD Pointer Request Vector
};

/*//Warning! Does not Contruct or otherwise initialize array elements!
template<class T> class SharedArray {
private:
void *a;

int &refCount() { MYASSERT(a); return *(int*)a; }
void *getDataPtr() const { return ((int*)a) + 1; }

void allocate(size_t size) {
MYASSERT(a == NULL);
DEGUB("SharedArray allocate %i\n", size);
if(size*sizeof(T) > 100*M)
throw generic_fatal_exception("SharedArray size: " + size);

if(size == 0)
a = NULL;
else {
a = malloc(size*sizeof(T)+sizeof(int));
if(!_CrtIsValidHeapPointer(a))
throw generic_fatal_exception("malloc failed in SharedArray");
refCount() = 1;
DEGUB("SharedArray allocated 0x%08X\n", a);
}
}
void release() {
DEGUB("SharedArray release 0x%08X @ count %i... ", a, refCount());
if(a) {
if(--refCount() == 0) {
free(a);
DEGUB("Freed.\n");
a = NULL;
} else {
DEGUB("Not freed.\n");
}
} else {
DEGUB("NULL.\n");
}
}
public:
SharedArray(size_t size) : a(NULL) {
allocate(size);
}
SharedArray(const SharedArray &other) : a(other.a) {
refCount()++;
DEGUB("SharedArray created with 0x%08X. New count: %i\n", a, refCount());
}
SharedArray &operator=(const SharedArray &other) {
release();
a = other.a;
refCount()++;
DEGUB("SharedArray assigned 0x%08X. New count: %i\n", a, refCount());
return *this;
}
~SharedArray() {
release();
}

operator T*() { return (T *)getDataPtr(); }
operator const T*() const { return (T *)getDataPtr(); }
T* p() { return (T *)getDataPtr(); }
const T* p() const { return (T *)getDataPtr(); }
size_t size() const { return _msize(a) - sizeof(int); }
int refCount() const { MYASSERT(a); return *(const int*)a; }
};*/

class CompiledDisplayList : public DynaRecBlockBase {
public:
	CompiledDisplayList(const DLRecBuf &recbuf, DWORD dlsize);
	~CompiledDisplayList();
	typedef void (*sfunc)();
	void run();
	const DWORD dl_size;
private:
	CompiledDisplayList& operator=(const CompiledDisplayList&);
	IUnknown** m_resources() { return (IUnknown**)(rcb() + recbuf_size()); }
	const size_t m_nres;
	DWORD* m_dwords() { return (DWORD*)(m_resources() + m_nres); }
};

class XFHandlerRec {
public:
	static void call(GP *that, void (GP::*func)(DWORD), DWORD d);
	static void call(GP *that, void (GP::*func)(const DWORD*), const DWORD *data);
	static void call(GP *that, void (GP::*func)(DWORD,DWORD), DWORD index, DWORD d);
	static void call(GP *that, void (GP::*func)(DWORD,const DWORD*), DWORD index,
		const DWORD *data);

	static void call(GP *that, void (GP::*func)(DWORD,const float*), DWORD index,
		const float *data);
	static void call(GP *that, void (GP::*func)(DWORD,const float*,bool), DWORD index,
		const float *data, bool b);
	static void call_if(GP *that, bool cond, void (GP::*func)(DWORD,const float*),
		DWORD index, const float *data); //bool must be ignored here, I think
	static const bool degub = false;
};
class XFHandlerRecIndx {
public:
	static void call(GP *that, void (GP::*func)(DWORD), DWORD d);
	static void call(GP *that, void (GP::*func)(const DWORD*), const DWORD *data);
	static void call(GP *that, void (GP::*func)(DWORD,DWORD), DWORD index, DWORD d);
	static void call(GP *that, void (GP::*func)(DWORD,const DWORD*), DWORD index,
		const DWORD *data);

	static void call(GP *that, void (GP::*func)(DWORD,const float*), DWORD index,
		const float *data);
	static void call(GP *that, void (GP::*func)(DWORD,const float*,bool), DWORD index,
		const float *data, bool b);
	static void call_if(GP *that, bool cond, void (GP::*func)(DWORD,const float*),
		DWORD index, const float *data); //cond must be ignored here, I think
	static const bool degub = false;
};

#endif	//GP_DLREC_H
